/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.Filters;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.Streams;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.SubscriptionConfig;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.Subscriptions;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of yrtIetfEventNotifications.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YrtIetfEventNotificationsOpParam extends InnerModelObject implements YrtIetfEventNotifications {
    protected Streams streams;
    protected Filters filters;
    protected SubscriptionConfig subscriptionConfig;
    protected Subscriptions subscriptions;

    @Override
    public Streams streams() {
        return streams;
    }

    @Override
    public Filters filters() {
        return filters;
    }

    @Override
    public SubscriptionConfig subscriptionConfig() {
        return subscriptionConfig;
    }

    @Override
    public Subscriptions subscriptions() {
        return subscriptions;
    }

    @Override
    public void streams(Streams streams) {
        this.streams = streams;
    }

    @Override
    public void filters(Filters filters) {
        this.filters = filters;
    }

    @Override
    public void subscriptionConfig(SubscriptionConfig subscriptionConfig) {
        this.subscriptionConfig = subscriptionConfig;
    }

    @Override
    public void subscriptions(Subscriptions subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Override
    public int hashCode() {
        return Objects.hash(streams, filters, subscriptionConfig, subscriptions);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YrtIetfEventNotificationsOpParam) {
            YrtIetfEventNotificationsOpParam other = (YrtIetfEventNotificationsOpParam) obj;
            return
                Objects.deepEquals(streams, other.streams) &&
                Objects.deepEquals(filters, other.filters) &&
                Objects.deepEquals(subscriptionConfig, other.subscriptionConfig) &&
                Objects.deepEquals(subscriptions, other.subscriptions);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("streams=" + streams)
            .add("filters=" + filters)
            .add("subscriptionConfig=" + subscriptionConfig)
            .add("subscriptions=" + subscriptions)
            .toString();
    }

    /**
     * Creates an instance of yrtIetfEventNotificationsOpParam.
     */
    public YrtIetfEventNotificationsOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}