/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

/**
 * Represents the implementation of encodeXml.
 */
public abstract class EncodeXml extends Encodings {

    /**
     * Returns the attribute encode-xml.
     *
     * @return encode-xml value of encode-xml
     */
    public static String encodeXmlToString() {
        return "encode-xml";
    }

    /**
     * Returns the object of encodeXml fromString input String encodeXml.
     *
     * @param valInString value of input String
     * @return encodeXml
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("encode-xml")) {
            return EncodeXml.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}