/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.ErrorDataNotAuthorized;

/**
 * Represents the implementation of error.
 */
public abstract class Error extends SubscriptionResultIdentity {

    /**
     * Returns the attribute error.
     *
     * @return error value of error
     */
    public static String errorToString() {
        return "error";
    }

    /**
     * Returns the object of error fromString input String error.
     *
     * @param valInString value of input String
     * @return error
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("error")) {
            return Error.class;
        } else if (valInString.equals("error-no-such-subscription")) {
            return ErrorNoSuchSubscription.class;
        } else if (valInString.equals("error-no-such-option")) {
            return ErrorNoSuchOption.class;
        } else if (valInString.equals("error-insufficient-resources")) {
            return ErrorInsufficientResources.class;
        } else if (valInString.equals("error-configured-subscription")) {
            return ErrorConfiguredSubscription.class;
        } else if (valInString.equals("error-other")) {
            return ErrorOther.class;
        } else if (valInString.equals("error-data-not-authorized")) {
            return ErrorDataNotAuthorized.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}