/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.modifysubscription;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.SubscriptionResultTypedef;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.subscriptionresponse.Result;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of modifySubscriptionOutput.
 */
public interface ModifySubscriptionOutput extends Augmentable  {

    /**
     * Identify the leaf of ModifySubscriptionOutput.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents subscriptionResult.
         */
        SUBSCRIPTIONRESULT(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute subscriptionResult.
     *
     * @return subscriptionResult value of subscriptionResult
     */
    SubscriptionResultTypedef subscriptionResult();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute result.
     *
     * @return result value of result
     */
    Result result();

    /**
     * Sets the attribute subscriptionResult.
     *
     * @param subscriptionResult value of subscriptionResult
     */
    void subscriptionResult(SubscriptionResultTypedef subscriptionResult);

    /**
     * Sets the attribute result.
     *
     * @param result value of result
     */
    void result(Result result);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}