/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508;

import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.Interfaces;
import org.onosproject.yang.gen.v1.yrtietfinterfaces.rev20140508.yrtietfinterfaces.InterfacesState;

/**
 * Abstraction of an entity which represents the functionality of yrtIetfInterfaces.
 */
public interface YrtIetfInterfaces {

    /**
     * Returns the attribute interfaces.
     *
     * @return interfaces value of interfaces
     */
    Interfaces interfaces();

    /**
     * Returns the attribute interfacesState.
     *
     * @return interfacesState value of interfacesState
     */
    InterfacesState interfacesState();

    /**
     * Sets the attribute interfaces.
     *
     * @param interfaces value of interfaces
     */
    void interfaces(Interfaces interfaces);

    /**
     * Sets the attribute interfacesState.
     *
     * @param interfacesState value of interfacesState
     */
    void interfacesState(InterfacesState interfacesState);

}