/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftemplstypes.rev20170310.yrtietftemplstypes.bfdencapmodetype;

/**
 * Represents ENUM data of bfdEncapModeTypeEnum.
 */
public enum BfdEncapModeTypeEnum {

    /**
     * Represents gal.
     */
    GAL(0, "gal"),

    /**
     * Represents ip.
     */
    IP(1, "ip");

    private int bfdEncapModeTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of bfdEncapModeTypeEnum.
     *
     * @param bfdEncapModeTypeEnum value of bfdEncapModeTypeEnum
     */
     BfdEncapModeTypeEnum(int bfdEncapModeTypeEnum, String schemaName) {
        this.bfdEncapModeTypeEnum = bfdEncapModeTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of bfdEncapModeTypeEnum for.
     *
     * @param value value of bfdEncapModeTypeEnum for
     * @return bfdEncapModeTypeEnum for
     */
    public static BfdEncapModeTypeEnum of(int value) {
        switch (value) {
            case 0:
                return BfdEncapModeTypeEnum.GAL;
            case 1:
                return BfdEncapModeTypeEnum.IP;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of bfdEncapModeTypeEnum for.
     *
     * @param value value of bfdEncapModeTypeEnum for
     * @return bfdEncapModeTypeEnum for
     */
    public static BfdEncapModeTypeEnum of(String value) {
        switch (value) {
            case "gal":
                return BfdEncapModeTypeEnum.GAL;
            case "ip":
                return BfdEncapModeTypeEnum.IP;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute bfdEncapModeTypeEnum.
     *
     * @return bfdEncapModeTypeEnum value of bfdEncapModeTypeEnum
     */
    public int bfdEncapModeTypeEnum() {
        return bfdEncapModeTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
