/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of protOtu2e.
 */
public abstract class ProtOtu2e extends TributaryProtocolType {

    /**
     * Returns the attribute prot-OTU2e.
     *
     * @return prot-OTU2e value of prot-OTU2e
     */
    public static String protOtu2eToString() {
        return "prot-OTU2e";
    }

    /**
     * Returns the object of protOtu2e fromString input String protOtu2e.
     *
     * @param valInString value of input String
     * @return protOtu2e
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("prot-OTU2e")) {
            return ProtOtu2e.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}