/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of tributarySlotGranularity.
 */
public abstract class TributarySlotGranularity {

    /**
     * Returns the attribute tributary-slot-granularity.
     *
     * @return tributary-slot-granularity value of tributary-slot-granularity
     */
    public static String tributarySlotGranularityToString() {
        return "tributary-slot-granularity";
    }

    /**
     * Returns the object of tributarySlotGranularity fromString input String tributarySlotGranularity.
     *
     * @param valInString value of input String
     * @return tributarySlotGranularity
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("tributary-slot-granularity")) {
            return TributarySlotGranularity.class;
        } else if (valInString.equals("tsg-1.25G")) {
            return Tsg125g.class;
        } else if (valInString.equals("tsg-2.5G")) {
            return Tsg25g.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}