/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription;

/**
 * Represents the implementation of encodings.
 */
public abstract class Encodings {

    /**
     * Returns the attribute encodings.
     *
     * @return encodings value of encodings
     */
    public static String encodingsToString() {
        return "encodings";
    }

    /**
     * Returns the object of encodings fromString input String encodings.
     *
     * @param valInString value of input String
     * @return encodings
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("encodings")) {
            return Encodings.class;
        } else if (valInString.equals("encode-xml")) {
            return EncodeXml.class;
        } else if (valInString.equals("encode-json")) {
            return EncodeJson.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}