/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.establishsubscription.establishsubscriptionoutput.result.nosuccess;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedNoSuccess.
 */
public class DefaultAugmentedNoSuccess extends InnerModelObject implements AugmentedNoSuccess {
    protected DateAndTime replayStartTimeHint;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public DateAndTime replayStartTimeHint() {
        return replayStartTimeHint;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void replayStartTimeHint(DateAndTime replayStartTimeHint) {
        valueLeafFlags.set(LeafIdentifier.REPLAYSTARTTIMEHINT.getLeafIndex());
        this.replayStartTimeHint = replayStartTimeHint;
    }

    @Override
    public int hashCode() {
        return Objects.hash(replayStartTimeHint, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedNoSuccess) {
            DefaultAugmentedNoSuccess other = (DefaultAugmentedNoSuccess) obj;
            return
                Objects.deepEquals(replayStartTimeHint, other.replayStartTimeHint) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("replayStartTimeHint=" + replayStartTimeHint)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedNoSuccess.
     */
    public DefaultAugmentedNoSuccess() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}