/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.configurationschedules;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.Xpath10;
import org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.Operation;
import org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.configurationschedules.target.DataValue;
import org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.configurationschedules.target.State;
import org.onosproject.yang.gen.v11.actnietfschedule.rev20170306.actnietfschedule.schedules.Schedules;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of target.
 */
public interface Target extends Augmentable  {

    /**
     * Identify the leaf of Target.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents object.
         */
        OBJECT(1),
        /**
         * Represents operation.
         */
        OPERATION(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute object.
     *
     * @return object value of object
     */
    Xpath10 object();

    /**
     * Returns the attribute operation.
     *
     * @return operation value of operation
     */
    Operation operation();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute dataValue.
     *
     * @return dataValue value of dataValue
     */
    DataValue dataValue();

    /**
     * Returns the attribute state.
     *
     * @return state value of state
     */
    State state();

    /**
     * Returns the attribute schedules.
     *
     * @return schedules value of schedules
     */
    Schedules schedules();

    /**
     * Sets the attribute object.
     *
     * @param object value of object
     */
    void object(Xpath10 object);

    /**
     * Sets the attribute operation.
     *
     * @param operation value of operation
     */
    void operation(Operation operation);

    /**
     * Sets the attribute dataValue.
     *
     * @param dataValue value of dataValue
     */
    void dataValue(DataValue dataValue);

    /**
     * Sets the attribute state.
     *
     * @param state value of state
     */
    void state(State state);

    /**
     * Sets the attribute schedules.
     *
     * @param schedules value of schedules
     */
    void schedules(Schedules schedules);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}