/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lspsstategrouping;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.lspsstategrouping.lspsstate.Lsp;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of lspsState.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultLspsState extends InnerModelObject implements LspsState {
    protected List<Lsp> lsp;

    @Override
    public List<Lsp> lsp() {
        return lsp;
    }

    @Override
    public void lsp(List<Lsp> lsp) {
        this.lsp = lsp;
    }

    @Override
    public void addToLsp(Lsp addTo) {
        if (lsp == null) {
            lsp = new ArrayList<>();
        }
        lsp.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(lsp);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultLspsState) {
            DefaultLspsState other = (DefaultLspsState) obj;
            return
                Objects.deepEquals(lsp, other.lsp);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("lsp=" + lsp)
            .toString();
    }


    /**
     * Creates an instance of defaultLspsState.
     */
    public DefaultLspsState() {
    }

}