/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.teoptimizationcriterion.optimizationcriterion;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TePathNumericalProperty;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.teoptimizationcriterion.optimizationcriterion.metric.GoalEnum;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of metric.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultMetric extends InnerModelObject 
        implements Metric, MultiInstanceObject<MetricKeys> {
    protected Class<? extends TePathNumericalProperty> name;
    protected GoalEnum goal;
    protected short weight;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public Class<? extends TePathNumericalProperty> name() {
        return name;
    }

    @Override
    public GoalEnum goal() {
        return goal;
    }

    @Override
    public short weight() {
        return weight;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void name(Class<? extends TePathNumericalProperty> name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void goal(GoalEnum goal) {
        valueLeafFlags.set(LeafIdentifier.GOAL.getLeafIndex());
        this.goal = goal;
    }

    @Override
    public void weight(short weight) {
        valueLeafFlags.set(LeafIdentifier.WEIGHT.getLeafIndex());
        this.weight = weight;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, goal, weight, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultMetric) {
            DefaultMetric other = (DefaultMetric) obj;
            return
                Objects.deepEquals(name, other.name) &&
                Objects.deepEquals(goal, other.goal) &&
                Objects.deepEquals(weight, other.weight) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("name=" + name)
            .add("goal=" + goal)
            .add("weight=" + weight)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultMetric.
     */
    public DefaultMetric() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}