/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.bandwidth;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.bandwidth.autobandwidth.Config;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.bandwidth.autobandwidth.Overflow;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.bandwidth.autobandwidth.State;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.bandwidth.autobandwidth.Underflow;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of autoBandwidth.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAutoBandwidth extends InnerModelObject implements AutoBandwidth {
    protected Config config;
    protected State state;
    protected Overflow overflow;
    protected Underflow underflow;

    @Override
    public Config config() {
        return config;
    }

    @Override
    public State state() {
        return state;
    }

    @Override
    public Overflow overflow() {
        return overflow;
    }

    @Override
    public Underflow underflow() {
        return underflow;
    }

    @Override
    public void config(Config config) {
        this.config = config;
    }

    @Override
    public void state(State state) {
        this.state = state;
    }

    @Override
    public void overflow(Overflow overflow) {
        this.overflow = overflow;
    }

    @Override
    public void underflow(Underflow underflow) {
        this.underflow = underflow;
    }

    @Override
    public int hashCode() {
        return Objects.hash(config, state, overflow, underflow);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAutoBandwidth) {
            DefaultAutoBandwidth other = (DefaultAutoBandwidth) obj;
            return
                Objects.deepEquals(config, other.config) &&
                Objects.deepEquals(state, other.state) &&
                Objects.deepEquals(overflow, other.overflow) &&
                Objects.deepEquals(underflow, other.underflow);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("config=" + config)
            .add("state=" + state)
            .add("overflow=" + overflow)
            .add("underflow=" + underflow)
            .toString();
    }


    /**
     * Creates an instance of defaultAutoBandwidth.
     */
    public DefaultAutoBandwidth() {
    }

}