/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsgrouping;

import java.util.List;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsgrouping.tunnels.Tunnel;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tunnelsgrouping.tunnels.TunnelP2Mp;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of tunnels.
 */
public interface Tunnels extends Augmentable  {

    /**
     * Returns the attribute tunnel.
     *
     * @return tunnel list of tunnel
     */
    List<Tunnel> tunnel();

    /**
     * Returns the attribute tunnelP2Mp.
     *
     * @return tunnelP2Mp list of tunnelP2Mp
     */
    List<TunnelP2Mp> tunnelP2Mp();

    /**
     * Sets the attribute tunnel.
     *
     * @param tunnel list of tunnel
     */
    void tunnel(List<Tunnel> tunnel);

    /**
     * Sets the attribute tunnelP2Mp.
     *
     * @param tunnelP2Mp list of tunnelP2Mp
     */
    void tunnelP2Mp(List<TunnelP2Mp> tunnelP2Mp);

    /**
     * Adds to the list of tunnel.
     *
     * @param addTo value of tunnel
     */
    void addToTunnel(Tunnel addTo);

    /**
     * Adds to the list of tunnelP2Mp.
     *
     * @param addTo value of tunnelP2Mp
     */
    void addToTunnelP2Mp(TunnelP2Mp addTo);

}