/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.LspEncodingTypes;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.LspProtType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.PathMetricType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.SwitchingCapabilities;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeGlobalId;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeTopologyId;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TunnelType;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes.ClientSignal;
import org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes.TributaryProtocolType;
import org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes.TributarySlotGranularity;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput.request.P2PprimaryPaths;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput.request.P2PsecondaryPaths;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntunnelendpoint.DstTributarySlots;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntunnelendpoint.PayloadTreatmentEnum;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntunnelendpoint.SrcTributarySlots;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of request.
 */
public interface Request extends Augmentable  {

    /**
     * Identify the leaf of Request.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents id.
         */
        ID(1),
        /**
         * Represents type.
         */
        TYPE(2),
        /**
         * Represents source.
         */
        SOURCE(3),
        /**
         * Represents destination.
         */
        DESTINATION(4),
        /**
         * Represents srcTpId.
         */
        SRCTPID(5),
        /**
         * Represents dstTpId.
         */
        DSTTPID(6),
        /**
         * Represents switchingLayer.
         */
        SWITCHINGLAYER(7),
        /**
         * Represents encoding.
         */
        ENCODING(8),
        /**
         * Represents protectionType.
         */
        PROTECTIONTYPE(9),
        /**
         * Represents providerId.
         */
        PROVIDERID(10),
        /**
         * Represents clientId.
         */
        CLIENTID(11),
        /**
         * Represents teTopologyId.
         */
        TETOPOLOGYID(12),
        /**
         * Represents setupPriority.
         */
        SETUPPRIORITY(13),
        /**
         * Represents holdPriority.
         */
        HOLDPRIORITY(14),
        /**
         * Represents tePathMetricType.
         */
        TEPATHMETRICTYPE(15),
        /**
         * Represents oduType.
         */
        ODUTYPE(16),
        /**
         * Represents payloadTreatment.
         */
        PAYLOADTREATMENT(17),
        /**
         * Represents srcClientSignal.
         */
        SRCCLIENTSIGNAL(18),
        /**
         * Represents srcTpn.
         */
        SRCTPN(19),
        /**
         * Represents srcTsg.
         */
        SRCTSG(20),
        /**
         * Represents srcTributarySlotCount.
         */
        SRCTRIBUTARYSLOTCOUNT(21),
        /**
         * Represents dstClientSignal.
         */
        DSTCLIENTSIGNAL(22),
        /**
         * Represents dstTpn.
         */
        DSTTPN(23),
        /**
         * Represents dstTsg.
         */
        DSTTSG(24),
        /**
         * Represents dstTributarySlotCount.
         */
        DSTTRIBUTARYSLOTCOUNT(25);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute id.
     *
     * @return id value of id
     */
    short id();

    /**
     * Returns the attribute type.
     *
     * @return type value of type
     */
    Class<? extends TunnelType> type();

    /**
     * Returns the attribute source.
     *
     * @return source value of source
     */
    IpAddress source();

    /**
     * Returns the attribute destination.
     *
     * @return destination value of destination
     */
    IpAddress destination();

    /**
     * Returns the attribute srcTpId.
     *
     * @return srcTpId value of srcTpId
     */
    byte[] srcTpId();

    /**
     * Returns the attribute dstTpId.
     *
     * @return dstTpId value of dstTpId
     */
    byte[] dstTpId();

    /**
     * Returns the attribute switchingLayer.
     *
     * @return switchingLayer value of switchingLayer
     */
    Class<? extends SwitchingCapabilities> switchingLayer();

    /**
     * Returns the attribute encoding.
     *
     * @return encoding value of encoding
     */
    Class<? extends LspEncodingTypes> encoding();

    /**
     * Returns the attribute protectionType.
     *
     * @return protectionType value of protectionType
     */
    Class<? extends LspProtType> protectionType();

    /**
     * Returns the attribute providerId.
     *
     * @return providerId value of providerId
     */
    TeGlobalId providerId();

    /**
     * Returns the attribute clientId.
     *
     * @return clientId value of clientId
     */
    TeGlobalId clientId();

    /**
     * Returns the attribute teTopologyId.
     *
     * @return teTopologyId value of teTopologyId
     */
    TeTopologyId teTopologyId();

    /**
     * Returns the attribute setupPriority.
     *
     * @return setupPriority value of setupPriority
     */
    short setupPriority();

    /**
     * Returns the attribute holdPriority.
     *
     * @return holdPriority value of holdPriority
     */
    short holdPriority();

    /**
     * Returns the attribute tePathMetricType.
     *
     * @return tePathMetricType value of tePathMetricType
     */
    Class<? extends PathMetricType> tePathMetricType();

    /**
     * Returns the attribute oduType.
     *
     * @return oduType value of oduType
     */
    Class<? extends TributaryProtocolType> oduType();

    /**
     * Returns the attribute payloadTreatment.
     *
     * @return payloadTreatment value of payloadTreatment
     */
    PayloadTreatmentEnum payloadTreatment();

    /**
     * Returns the attribute srcClientSignal.
     *
     * @return srcClientSignal value of srcClientSignal
     */
    Class<? extends ClientSignal> srcClientSignal();

    /**
     * Returns the attribute srcTpn.
     *
     * @return srcTpn value of srcTpn
     */
    int srcTpn();

    /**
     * Returns the attribute srcTsg.
     *
     * @return srcTsg value of srcTsg
     */
    Class<? extends TributarySlotGranularity> srcTsg();

    /**
     * Returns the attribute srcTributarySlotCount.
     *
     * @return srcTributarySlotCount value of srcTributarySlotCount
     */
    int srcTributarySlotCount();

    /**
     * Returns the attribute dstClientSignal.
     *
     * @return dstClientSignal value of dstClientSignal
     */
    Class<? extends ClientSignal> dstClientSignal();

    /**
     * Returns the attribute dstTpn.
     *
     * @return dstTpn value of dstTpn
     */
    int dstTpn();

    /**
     * Returns the attribute dstTsg.
     *
     * @return dstTsg value of dstTsg
     */
    Class<? extends TributarySlotGranularity> dstTsg();

    /**
     * Returns the attribute dstTributarySlotCount.
     *
     * @return dstTributarySlotCount value of dstTributarySlotCount
     */
    int dstTributarySlotCount();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute p2PprimaryPaths.
     *
     * @return p2PprimaryPaths value of p2PprimaryPaths
     */
    P2PprimaryPaths p2PprimaryPaths();

    /**
     * Returns the attribute p2PsecondaryPaths.
     *
     * @return p2PsecondaryPaths value of p2PsecondaryPaths
     */
    P2PsecondaryPaths p2PsecondaryPaths();

    /**
     * Returns the attribute srcTributarySlots.
     *
     * @return srcTributarySlots value of srcTributarySlots
     */
    SrcTributarySlots srcTributarySlots();

    /**
     * Returns the attribute dstTributarySlots.
     *
     * @return dstTributarySlots value of dstTributarySlots
     */
    DstTributarySlots dstTributarySlots();

    /**
     * Sets the attribute id.
     *
     * @param id value of id
     */
    void id(short id);

    /**
     * Sets the attribute type.
     *
     * @param type value of type
     */
    void type(Class<? extends TunnelType> type);

    /**
     * Sets the attribute source.
     *
     * @param source value of source
     */
    void source(IpAddress source);

    /**
     * Sets the attribute destination.
     *
     * @param destination value of destination
     */
    void destination(IpAddress destination);

    /**
     * Sets the attribute srcTpId.
     *
     * @param srcTpId value of srcTpId
     */
    void srcTpId(byte[] srcTpId);

    /**
     * Sets the attribute dstTpId.
     *
     * @param dstTpId value of dstTpId
     */
    void dstTpId(byte[] dstTpId);

    /**
     * Sets the attribute switchingLayer.
     *
     * @param switchingLayer value of switchingLayer
     */
    void switchingLayer(Class<? extends SwitchingCapabilities> switchingLayer);

    /**
     * Sets the attribute encoding.
     *
     * @param encoding value of encoding
     */
    void encoding(Class<? extends LspEncodingTypes> encoding);

    /**
     * Sets the attribute protectionType.
     *
     * @param protectionType value of protectionType
     */
    void protectionType(Class<? extends LspProtType> protectionType);

    /**
     * Sets the attribute providerId.
     *
     * @param providerId value of providerId
     */
    void providerId(TeGlobalId providerId);

    /**
     * Sets the attribute clientId.
     *
     * @param clientId value of clientId
     */
    void clientId(TeGlobalId clientId);

    /**
     * Sets the attribute teTopologyId.
     *
     * @param teTopologyId value of teTopologyId
     */
    void teTopologyId(TeTopologyId teTopologyId);

    /**
     * Sets the attribute setupPriority.
     *
     * @param setupPriority value of setupPriority
     */
    void setupPriority(short setupPriority);

    /**
     * Sets the attribute holdPriority.
     *
     * @param holdPriority value of holdPriority
     */
    void holdPriority(short holdPriority);

    /**
     * Sets the attribute tePathMetricType.
     *
     * @param tePathMetricType value of tePathMetricType
     */
    void tePathMetricType(Class<? extends PathMetricType> tePathMetricType);

    /**
     * Sets the attribute oduType.
     *
     * @param oduType value of oduType
     */
    void oduType(Class<? extends TributaryProtocolType> oduType);

    /**
     * Sets the attribute payloadTreatment.
     *
     * @param payloadTreatment value of payloadTreatment
     */
    void payloadTreatment(PayloadTreatmentEnum payloadTreatment);

    /**
     * Sets the attribute srcClientSignal.
     *
     * @param srcClientSignal value of srcClientSignal
     */
    void srcClientSignal(Class<? extends ClientSignal> srcClientSignal);

    /**
     * Sets the attribute srcTpn.
     *
     * @param srcTpn value of srcTpn
     */
    void srcTpn(int srcTpn);

    /**
     * Sets the attribute srcTsg.
     *
     * @param srcTsg value of srcTsg
     */
    void srcTsg(Class<? extends TributarySlotGranularity> srcTsg);

    /**
     * Sets the attribute srcTributarySlotCount.
     *
     * @param srcTributarySlotCount value of srcTributarySlotCount
     */
    void srcTributarySlotCount(int srcTributarySlotCount);

    /**
     * Sets the attribute dstClientSignal.
     *
     * @param dstClientSignal value of dstClientSignal
     */
    void dstClientSignal(Class<? extends ClientSignal> dstClientSignal);

    /**
     * Sets the attribute dstTpn.
     *
     * @param dstTpn value of dstTpn
     */
    void dstTpn(int dstTpn);

    /**
     * Sets the attribute dstTsg.
     *
     * @param dstTsg value of dstTsg
     */
    void dstTsg(Class<? extends TributarySlotGranularity> dstTsg);

    /**
     * Sets the attribute dstTributarySlotCount.
     *
     * @param dstTributarySlotCount value of dstTributarySlotCount
     */
    void dstTributarySlotCount(int dstTributarySlotCount);

    /**
     * Sets the attribute p2PprimaryPaths.
     *
     * @param p2PprimaryPaths value of p2PprimaryPaths
     */
    void p2PprimaryPaths(P2PprimaryPaths p2PprimaryPaths);

    /**
     * Sets the attribute p2PsecondaryPaths.
     *
     * @param p2PsecondaryPaths value of p2PsecondaryPaths
     */
    void p2PsecondaryPaths(P2PsecondaryPaths p2PsecondaryPaths);

    /**
     * Sets the attribute srcTributarySlots.
     *
     * @param srcTributarySlots value of srcTributarySlots
     */
    void srcTributarySlots(SrcTributarySlots srcTributarySlots);

    /**
     * Sets the attribute dstTributarySlots.
     *
     * @param dstTributarySlots value of dstTributarySlots
     */
    void dstTributarySlots(DstTributarySlots dstTributarySlots);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}