/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeoutput;

import java.util.BitSet;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeoutput.result.P2PprimaryPaths;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeoutput.result.P2PsecondaryPaths;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of result.
 */
public interface Result extends Augmentable  {

    /**
     * Identify the leaf of Result.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents id.
         */
        ID(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute id.
     *
     * @return id value of id
     */
    short id();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute p2PprimaryPaths.
     *
     * @return p2PprimaryPaths value of p2PprimaryPaths
     */
    P2PprimaryPaths p2PprimaryPaths();

    /**
     * Returns the attribute p2PsecondaryPaths.
     *
     * @return p2PsecondaryPaths value of p2PsecondaryPaths
     */
    P2PsecondaryPaths p2PsecondaryPaths();

    /**
     * Sets the attribute id.
     *
     * @param id value of id
     */
    void id(short id);

    /**
     * Sets the attribute p2PprimaryPaths.
     *
     * @param p2PprimaryPaths value of p2PprimaryPaths
     */
    void p2PprimaryPaths(P2PprimaryPaths p2PprimaryPaths);

    /**
     * Sets the attribute p2PsecondaryPaths.
     *
     * @param p2PsecondaryPaths value of p2PsecondaryPaths
     */
    void p2PsecondaryPaths(P2PsecondaryPaths p2PsecondaryPaths);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}