/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush;

import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.StreamIdentity;

/**
 * Represents the implementation of customStream.
 */
public abstract class CustomStream extends StreamIdentity {

    /**
     * Returns the attribute custom-stream.
     *
     * @return custom-stream value of custom-stream
     */
    public static String customStreamToString() {
        return "custom-stream";
    }

    /**
     * Returns the object of customStream fromString input String customStream.
     *
     * @param valInString value of input String
     * @return customStream
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("custom-stream")) {
            return CustomStream.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}