/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.changetype;

/**
 * Represents ENUM data of changeTypeEnum.
 */
public enum ChangeTypeEnum {

    /**
     * Represents create.
     */
    CREATE(0, "create"),

    /**
     * Represents delete.
     */
    DELETE(1, "delete"),

    /**
     * Represents modify.
     */
    MODIFY(2, "modify");

    private int changeTypeEnum;
    private String schemaName;

    /**
     * Creates an instance of changeTypeEnum.
     *
     * @param changeTypeEnum value of changeTypeEnum
     */
     ChangeTypeEnum(int changeTypeEnum, String schemaName) {
        this.changeTypeEnum = changeTypeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of changeTypeEnum for.
     *
     * @param value value of changeTypeEnum for
     * @return changeTypeEnum for
     */
    public static ChangeTypeEnum of(int value) {
        switch (value) {
            case 0:
                return ChangeTypeEnum.CREATE;
            case 1:
                return ChangeTypeEnum.DELETE;
            case 2:
                return ChangeTypeEnum.MODIFY;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of changeTypeEnum for.
     *
     * @param value value of changeTypeEnum for
     * @return changeTypeEnum for
     */
    public static ChangeTypeEnum of(String value) {
        switch (value) {
            case "create":
                return ChangeTypeEnum.CREATE;
            case "delete":
                return ChangeTypeEnum.DELETE;
            case "modify":
                return ChangeTypeEnum.MODIFY;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute changeTypeEnum.
     *
     * @return changeTypeEnum value of changeTypeEnum
     */
    public int changeTypeEnum() {
        return changeTypeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
