/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel.utils.builtindatatype;

public enum YangDataTypes {
    INT8("int8"),
    INT16("int16"),
    INT32("int32"),
    INT64("int64"),
    UINT8("uint8"),
    UINT16("uint16"),
    UINT32("uint32"),
    UINT64("uint64"),
    DECIMAL64("decimal64"),
    STRING("string"),
    BOOLEAN("boolean"),
    ENUMERATION("enumeration"),
    BITS("bits"),
    BINARY("binary"),
    LEAFREF("leafref"),
    IDENTITYREF("identityref"),
    EMPTY("empty"),
    UNION("union"),
    INSTANCE_IDENTIFIER("instance-identifier"),
    DERIVED("derived");

    private final String definedType;

    private YangDataTypes(String definedType) {
        this.definedType = definedType;
    }

    public static YangDataTypes getType(String name) {
        name = name.replace("\"", "");
        for (YangDataTypes yangDataType : YangDataTypes.values()) {
            if (!yangDataType.definedType.toLowerCase().equals(name)) continue;
            return yangDataType;
        }
        return DERIVED;
    }

    public boolean isPrimitiveDataType() {
        return this == INT8 || this == INT16 || this == INT32 || this == INT64 || this == UINT8 || this == UINT16 || this == UINT32 || this == UINT64 || this == DECIMAL64 || this == BOOLEAN || this == EMPTY;
    }

    public boolean isNonRestrictedType() {
        return this == BOOLEAN || this == ENUMERATION || this == BITS || this == EMPTY || this == UNION || this == IDENTITYREF || this == LEAFREF;
    }
}

