/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangMaxElement;
import org.onosproject.yang.compiler.datamodel.YangMaxElementHolder;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class MaxElementsListener {
    private static final String POSITIVE_INTEGER_PATTERN = "[1-9][0-9]*";
    private static final String UNBOUNDED_KEYWORD = "unbounded";

    private MaxElementsListener() {
    }

    public static void processMaxElementsEntry(TreeWalkListener listener, GeneratedYangParser.MaxElementsStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.MAX_ELEMENT_DATA, "", ListenerErrorLocation.ENTRY);
        int maxElementsValue = MaxElementsListener.getValidMaxElementValue(ctx);
        YangMaxElement maxElement = new YangMaxElement();
        maxElement.setMaxElement(maxElementsValue);
        maxElement.setLineNumber(ctx.getStart().getLine());
        maxElement.setCharPosition(ctx.getStart().getCharPositionInLine());
        maxElement.setFileName(listener.getFileName());
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (!(tmpData instanceof YangMaxElementHolder)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.MAX_ELEMENT_DATA, "", ListenerErrorLocation.ENTRY));
        }
        YangMaxElementHolder holder = (YangMaxElementHolder)((Object)tmpData);
        holder.setMaxElements(maxElement);
    }

    private static int getValidMaxElementValue(GeneratedYangParser.MaxElementsStatementContext ctx) {
        int maxElementsValue;
        String value = ListenerUtil.removeQuotesAndHandleConcat(ctx.maxValue().getText());
        if (value.equals(UNBOUNDED_KEYWORD)) {
            maxElementsValue = Integer.MAX_VALUE;
        } else if (value.matches(POSITIVE_INTEGER_PATTERN)) {
            try {
                maxElementsValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(YangConstructType.MAX_ELEMENT_DATA) + " value " + value + " is not valid.");
                parserException.setLine(ctx.getStart().getLine());
                parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                throw parserException;
            }
        } else {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(YangConstructType.MAX_ELEMENT_DATA) + " value " + value + " is not valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return maxElementsValue;
    }
}

