/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.YangTypeDef;
import org.onosproject.yang.compiler.datamodel.YangUnion;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;

public final class UnionListener {
    private static final String UNION_CLASS_SUFFIX = "_union";

    private UnionListener() {
    }

    public static void processUnionEntry(TreeWalkListener listener, GeneratedYangParser.UnionSpecificationContext ctx) {
        Parsable typeData;
        YangUnion unionNode;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.UNION_DATA, "", ListenerErrorLocation.ENTRY);
        if (listener.getParsedDataStack().peek() instanceof YangType) {
            unionNode = YangDataModelFactory.getYangUnionNode(GeneratedLanguage.JAVA_GENERATION);
            typeData = listener.getParsedDataStack().pop();
            unionNode.setLineNumber(ctx.getStart().getLine());
            unionNode.setCharPosition(ctx.getStart().getCharPositionInLine());
            unionNode.setFileName(listener.getFileName());
            ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.UNION_DATA, "", ListenerErrorLocation.ENTRY);
            Parsable tmpData = listener.getParsedDataStack().peek();
            switch (tmpData.getYangConstructType()) {
                case LEAF_DATA: {
                    unionNode.setName(((YangLeaf)tmpData).getName() + UNION_CLASS_SUFFIX);
                    Parsable leaf = listener.getParsedDataStack().pop();
                    UnionListener.addChildToParentNode(listener, unionNode);
                    listener.getParsedDataStack().push(leaf);
                    break;
                }
                case LEAF_LIST_DATA: {
                    unionNode.setName(((YangLeafList)tmpData).getName() + UNION_CLASS_SUFFIX);
                    Parsable leafList = listener.getParsedDataStack().pop();
                    UnionListener.addChildToParentNode(listener, unionNode);
                    listener.getParsedDataStack().push(leafList);
                    break;
                }
                case UNION_DATA: {
                    YangUnion parentUnion = (YangUnion)tmpData;
                    unionNode.setName(parentUnion.getName() + UNION_CLASS_SUFFIX + parentUnion.getChildUnionNumber());
                    parentUnion.setChildUnionNumber(parentUnion.getChildUnionNumber() + 1);
                    UnionListener.addChildToParentNode(listener, unionNode);
                    break;
                }
                case TYPEDEF_DATA: {
                    YangTypeDef typeDef = (YangTypeDef)tmpData;
                    unionNode.setName(typeDef.getName() + UNION_CLASS_SUFFIX);
                    UnionListener.addChildToParentNode(listener, unionNode);
                    break;
                }
                default: {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.TYPE_DATA, ((YangType)typeData).getDataTypeName(), ListenerErrorLocation.ENTRY));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.UNION_DATA, "", ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(typeData);
        listener.getParsedDataStack().push(unionNode);
    }

    public static void processUnionExit(TreeWalkListener listener, GeneratedYangParser.UnionSpecificationContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.UNION_DATA, "", ListenerErrorLocation.EXIT);
        Parsable tmpUnionNode = listener.getParsedDataStack().peek();
        if (tmpUnionNode instanceof YangUnion) {
            YangUnion unionNode = (YangUnion)tmpUnionNode;
            listener.getParsedDataStack().pop();
            ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.UNION_DATA, "", ListenerErrorLocation.EXIT);
            Parsable tmpNode = listener.getParsedDataStack().peek();
            switch (tmpNode.getYangConstructType()) {
                case TYPE_DATA: {
                    YangType typeNode = (YangType)tmpNode;
                    typeNode.setDataTypeExtendedInfo(unionNode);
                    break;
                }
                default: {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.UNION_DATA, "", ListenerErrorLocation.EXIT));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.UNION_DATA, "", ListenerErrorLocation.EXIT));
        }
    }

    private static void addChildToParentNode(TreeWalkListener listener, YangUnion unionNode) {
        if (!(listener.getParsedDataStack().peek() instanceof YangNode)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.UNION_DATA, "", ListenerErrorLocation.ENTRY));
        }
        YangNode curNode = (YangNode)((Object)listener.getParsedDataStack().peek());
        try {
            curNode.addChild(unionNode);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.UNION_DATA, "", ListenerErrorLocation.ENTRY, e.getMessage()));
        }
    }
}

