/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of addressFamily.
 */
public abstract class AddressFamily {

    /**
     * Returns the attribute address-family.
     *
     * @return address-family value of address-family
     */
    public static String addressFamilyToString() {
        return "address-family";
    }

    /**
     * Returns the object of addressFamily fromString input String addressFamily.
     *
     * @param valInString value of input String
     * @return addressFamily
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("address-family")) {
            return AddressFamily.class;
        } else if (valInString.equals("ipv4")) {
            return Ipv4.class;
        } else if (valInString.equals("ipv6")) {
            return Ipv6.class;
        } else if (valInString.equals("nsap")) {
            return Nsap.class;
        } else if (valInString.equals("hdlc")) {
            return Hdlc.class;
        } else if (valInString.equals("bbn1822")) {
            return Bbn1822.class;
        } else if (valInString.equals("ieee802")) {
            return Ieee802.class;
        } else if (valInString.equals("e163")) {
            return E163.class;
        } else if (valInString.equals("e164")) {
            return E164.class;
        } else if (valInString.equals("f69")) {
            return F69.class;
        } else if (valInString.equals("x121")) {
            return X121.class;
        } else if (valInString.equals("ipx")) {
            return Ipx.class;
        } else if (valInString.equals("appletalk")) {
            return Appletalk.class;
        } else if (valInString.equals("decnet-iv")) {
            return DecnetIv.class;
        } else if (valInString.equals("vines")) {
            return Vines.class;
        } else if (valInString.equals("e164-nsap")) {
            return E164Nsap.class;
        } else if (valInString.equals("dns")) {
            return Dns.class;
        } else if (valInString.equals("dn")) {
            return Dn.class;
        } else if (valInString.equals("as-num")) {
            return AsNum.class;
        } else if (valInString.equals("xtp-v4")) {
            return XtpV4.class;
        } else if (valInString.equals("xtp-v6")) {
            return XtpV6.class;
        } else if (valInString.equals("xtp")) {
            return Xtp.class;
        } else if (valInString.equals("fc-port")) {
            return FcPort.class;
        } else if (valInString.equals("fc-node")) {
            return FcNode.class;
        } else if (valInString.equals("gwid")) {
            return Gwid.class;
        } else if (valInString.equals("l2vpn")) {
            return L2Vpn.class;
        } else if (valInString.equals("mpls-tp-section-eid")) {
            return MplsTpSectionEid.class;
        } else if (valInString.equals("mpls-tp-lsp-eid")) {
            return MplsTpLspEid.class;
        } else if (valInString.equals("mpls-tp-pwe-eid")) {
            return MplsTpPweEid.class;
        } else if (valInString.equals("mt-v4")) {
            return MtV4.class;
        } else if (valInString.equals("mt-v6")) {
            return MtV6.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}