/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of xtpV6.
 */
public abstract class XtpV6 extends AddressFamily {

    /**
     * Returns the attribute xtp-v6.
     *
     * @return xtp-v6 value of xtp-v6
     */
    public static String xtpV6ToString() {
        return "xtp-v6";
    }

    /**
     * Returns the object of xtpV6 fromString input String xtpV6.
     *
     * @param valInString value of input String
     * @return xtpV6
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("xtp-v6")) {
            return XtpV6.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}