/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.ipv4multicastsourceaddress;

import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.ipv4multicastsourceaddress.ipv4multicastsourceaddressunion.Ipv4MulticastSourceAddressUnionEnum1;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of ipv4MulticastSourceAddressUnion.
 */
public final class Ipv4MulticastSourceAddressUnion {
    private Ipv4MulticastSourceAddressUnionEnum1 enumeration;
    private Ipv4Address ipv4Address;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of ipv4MulticastSourceAddressUnion.
     */
    private Ipv4MulticastSourceAddressUnion() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public Ipv4MulticastSourceAddressUnion(Ipv4MulticastSourceAddressUnionEnum1 enumeration) {
        setValue.set(0);
        this.enumeration = enumeration;
    }

    /**
     * Creates an instance of ipv4Address.
     *
     * @param ipv4Address value of ipv4Address
     */
    public Ipv4MulticastSourceAddressUnion(Ipv4Address ipv4Address) {
        setValue.set(1);
        this.ipv4Address = ipv4Address;
    }

    /**
     * Returns the object of ipv4MulticastSourceAddressUnion for type enumeration.
     *
     * @param value value of ipv4MulticastSourceAddressUnion for type enumeration
     * @return ipv4MulticastSourceAddressUnion for type enumeration
     */
    public static Ipv4MulticastSourceAddressUnion of(Ipv4MulticastSourceAddressUnionEnum1 value) {
        return new Ipv4MulticastSourceAddressUnion(value);
    }

    /**
     * Returns the object of ipv4MulticastSourceAddressUnion for type ipv4Address.
     *
     * @param value value of ipv4MulticastSourceAddressUnion for type ipv4Address
     * @return ipv4MulticastSourceAddressUnion for type ipv4Address
     */
    public static Ipv4MulticastSourceAddressUnion of(Ipv4Address value) {
        return new Ipv4MulticastSourceAddressUnion(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public Ipv4MulticastSourceAddressUnionEnum1 enumeration() {
        return enumeration;
    }
    /**
     * Returns the attribute ipv4Address.
     *
     * @return ipv4Address value of ipv4Address
     */
    public Ipv4Address ipv4Address() {
        return ipv4Address;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(Ipv4MulticastSourceAddressUnionEnum1 enumeration) {
        this.enumeration = enumeration;
    }
    /**
     * Sets the attribute ipv4Address.
     *
     * @param ipv4Address value of ipv4Address
     */
    public void ipv4Address(Ipv4Address ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration, ipv4Address);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Ipv4MulticastSourceAddressUnion) {
            Ipv4MulticastSourceAddressUnion other = (Ipv4MulticastSourceAddressUnion) obj;
            return
                Objects.deepEquals(enumeration, other.enumeration) &&
                Objects.deepEquals(ipv4Address, other.ipv4Address);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return enumeration.toString();
        }
        if (setValue.get(1)) {
            return ipv4Address.toString();
        }
        return null;
    }
    /**
     * Returns the object of ipv4MulticastSourceAddressUnion fromString input String ipv4MulticastSourceAddressUnion.
     *
     * @param valInString value of input String
     * @return ipv4MulticastSourceAddressUnion
     */
    public static Ipv4MulticastSourceAddressUnion fromString(String valInString) {
        try {
            Ipv4MulticastSourceAddressUnionEnum1 tmpVal = Ipv4MulticastSourceAddressUnionEnum1.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            Ipv4Address tmpVal = Ipv4Address.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
