/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.timervaluemilliseconds.timervaluemillisecondsunion;

/**
 * Represents ENUM data of timerValueMillisecondsUnionEnum1.
 */
public enum TimerValueMillisecondsUnionEnum1 {

    /**
     * Represents infinity.
     */
    INFINITY(0, "infinity"),

    /**
     * Represents not-set.
     */
    NOT_SET(1, "not-set");

    private int timerValueMillisecondsUnionEnum1;
    private String schemaName;

    /**
     * Creates an instance of timerValueMillisecondsUnionEnum1.
     *
     * @param timerValueMillisecondsUnionEnum1 value of timerValueMillisecondsUnionEnum1
     */
     TimerValueMillisecondsUnionEnum1(int timerValueMillisecondsUnionEnum1, String schemaName) {
        this.timerValueMillisecondsUnionEnum1 = timerValueMillisecondsUnionEnum1;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of timerValueMillisecondsUnionEnum1 for.
     *
     * @param value value of timerValueMillisecondsUnionEnum1 for
     * @return timerValueMillisecondsUnionEnum1 for
     */
    public static TimerValueMillisecondsUnionEnum1 of(int value) {
        switch (value) {
            case 0:
                return TimerValueMillisecondsUnionEnum1.INFINITY;
            case 1:
                return TimerValueMillisecondsUnionEnum1.NOT_SET;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of timerValueMillisecondsUnionEnum1 for.
     *
     * @param value value of timerValueMillisecondsUnionEnum1 for
     * @return timerValueMillisecondsUnionEnum1 for
     */
    public static TimerValueMillisecondsUnionEnum1 of(String value) {
        switch (value) {
            case "infinity":
                return TimerValueMillisecondsUnionEnum1.INFINITY;
            case "not-set":
                return TimerValueMillisecondsUnionEnum1.NOT_SET;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute timerValueMillisecondsUnionEnum1.
     *
     * @return timerValueMillisecondsUnionEnum1 value of timerValueMillisecondsUnionEnum1
     */
    public int timerValueMillisecondsUnionEnum1() {
        return timerValueMillisecondsUnionEnum1;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
