/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

/**
 * Represents the implementation of provStateType.
 */
public abstract class ProvStateType {

    /**
     * Returns the attribute prov-state-type.
     *
     * @return prov-state-type value of prov-state-type
     */
    public static String provStateTypeToString() {
        return "prov-state-type";
    }

    /**
     * Returns the object of provStateType fromString input String provStateType.
     *
     * @param valInString value of input String
     * @return provStateType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("prov-state-type")) {
            return ProvStateType.class;
        } else if (valInString.equals("prov-state-down")) {
            return ProvStateDown.class;
        } else if (valInString.equals("prov-state-computing")) {
            return ProvStateComputing.class;
        } else if (valInString.equals("prov-state-computed-ok")) {
            return ProvStateComputedOk.class;
        } else if (valInString.equals("prov-state-computed-fail")) {
            return ProvStateComputedFail.class;
        } else if (valInString.equals("prov-state-setting-up")) {
            return ProvStateSettingUp.class;
        } else if (valInString.equals("prov-state-setup-fail")) {
            return ProvStateSetupFail.class;
        } else if (valInString.equals("prov-state-active")) {
            return ProvStateActive.class;
        } else if (valInString.equals("prov-state-tearing-down")) {
            return ProvStateTearingDown.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}