/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.tehoptype.TeHopTypeEnum;
import java.util.Objects;

/**
 * Represents the implementation of teHopType.
 */
public final class TeHopType {

    private TeHopTypeEnum enumeration;

    /**
     * Creates an instance of teHopType.
     */
    private TeHopType() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public TeHopType(TeHopTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of teHopType for type enumeration.
     *
     * @param value value of teHopType for type enumeration
     * @return teHopType for type enumeration
     */
    public static TeHopType of(TeHopTypeEnum value) {
        return new TeHopType(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public TeHopTypeEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(TeHopTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TeHopType) {
            TeHopType other = (TeHopType) obj;
            return
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of teHopType fromString input String teHopType.
     *
     * @param valInString value of input String
     * @return teHopType
     */
    public static TeHopType fromString(String valInString) {
        try {
            TeHopTypeEnum tmpVal = TeHopTypeEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
