/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.teoperstatus;

/**
 * Represents ENUM data of teOperStatusEnum.
 */
public enum TeOperStatusEnum {

    /**
     * Represents up.
     */
    UP(0, "up"),

    /**
     * Represents down.
     */
    DOWN(1, "down"),

    /**
     * Represents testing.
     */
    TESTING(2, "testing"),

    /**
     * Represents unknown.
     */
    UNKNOWN(3, "unknown"),

    /**
     * Represents preparing-maintenance.
     */
    PREPARING_MAINTENANCE(4, "preparing-maintenance"),

    /**
     * Represents maintenance.
     */
    MAINTENANCE(5, "maintenance");

    private int teOperStatusEnum;
    private String schemaName;

    /**
     * Creates an instance of teOperStatusEnum.
     *
     * @param teOperStatusEnum value of teOperStatusEnum
     */
     TeOperStatusEnum(int teOperStatusEnum, String schemaName) {
        this.teOperStatusEnum = teOperStatusEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of teOperStatusEnum for.
     *
     * @param value value of teOperStatusEnum for
     * @return teOperStatusEnum for
     */
    public static TeOperStatusEnum of(int value) {
        switch (value) {
            case 0:
                return TeOperStatusEnum.UP;
            case 1:
                return TeOperStatusEnum.DOWN;
            case 2:
                return TeOperStatusEnum.TESTING;
            case 3:
                return TeOperStatusEnum.UNKNOWN;
            case 4:
                return TeOperStatusEnum.PREPARING_MAINTENANCE;
            case 5:
                return TeOperStatusEnum.MAINTENANCE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of teOperStatusEnum for.
     *
     * @param value value of teOperStatusEnum for
     * @return teOperStatusEnum for
     */
    public static TeOperStatusEnum of(String value) {
        switch (value) {
            case "up":
                return TeOperStatusEnum.UP;
            case "down":
                return TeOperStatusEnum.DOWN;
            case "testing":
                return TeOperStatusEnum.TESTING;
            case "unknown":
                return TeOperStatusEnum.UNKNOWN;
            case "preparing-maintenance":
                return TeOperStatusEnum.PREPARING_MAINTENANCE;
            case "maintenance":
                return TeOperStatusEnum.MAINTENANCE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute teOperStatusEnum.
     *
     * @return teOperStatusEnum value of teOperStatusEnum
     */
    public int teOperStatusEnum() {
        return teOperStatusEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
