/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.exampleops.rev20160707.exampleops.reboot;

import java.util.BitSet;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of rebootOutput.
 */
public interface RebootOutput extends Augmentable  {

    /**
     * Identify the leaf of RebootOutput.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents rebootTime.
         */
        REBOOTTIME(1),
        /**
         * Represents message.
         */
        MESSAGE(2),
        /**
         * Represents language.
         */
        LANGUAGE(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute rebootTime.
     *
     * @return rebootTime value of rebootTime
     */
    String rebootTime();

    /**
     * Returns the attribute message.
     *
     * @return message value of message
     */
    String message();

    /**
     * Returns the attribute language.
     *
     * @return language value of language
     */
    String language();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute rebootTime.
     *
     * @param rebootTime value of rebootTime
     */
    void rebootTime(String rebootTime);

    /**
     * Sets the attribute message.
     *
     * @param message value of message
     */
    void message(String message);

    /**
     * Sets the attribute language.
     *
     * @param language value of language
     */
    void language(String language);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}