/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurity;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurityauthentication.Authentication;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurityencryption.Encryption;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of security.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultSecurity extends InnerModelObject implements Security {
    protected Authentication authentication;
    protected Encryption encryption;

    @Override
    public Authentication authentication() {
        return authentication;
    }

    @Override
    public Encryption encryption() {
        return encryption;
    }

    @Override
    public void authentication(Authentication authentication) {
        this.authentication = authentication;
    }

    @Override
    public void encryption(Encryption encryption) {
        this.encryption = encryption;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authentication, encryption);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSecurity) {
            DefaultSecurity other = (DefaultSecurity) obj;
            return
                Objects.deepEquals(authentication, other.authentication) &&
                Objects.deepEquals(encryption, other.encryption);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("authentication=" + authentication)
            .add("encryption=" + encryption)
            .toString();
    }


    /**
     * Creates an instance of defaultSecurity.
     */
    public DefaultSecurity() {
    }

}