/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.sites.site.sitenetworkaccesses.sitenetworkaccess.service.qos.qosprofile.qosprofile.augmentedl3vpnqosprofile.customunicom;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.classprofile.QosClass;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of inboundClasses.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultInboundClasses extends InnerModelObject implements InboundClasses {
    protected List<QosClass> qosClass;

    @Override
    public List<QosClass> qosClass() {
        return qosClass;
    }

    @Override
    public void qosClass(List<QosClass> qosClass) {
        this.qosClass = qosClass;
    }

    @Override
    public void addToQosClass(QosClass addTo) {
        if (qosClass == null) {
            qosClass = new ArrayList<>();
        }
        qosClass.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(qosClass);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultInboundClasses) {
            DefaultInboundClasses other = (DefaultInboundClasses) obj;
            return
                Objects.deepEquals(qosClass, other.qosClass);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("qosClass=" + qosClass)
            .toString();
    }


    /**
     * Creates an instance of defaultInboundClasses.
     */
    public DefaultInboundClasses() {
    }

}