/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata;

import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.uniontypedef.UnionTypedefUnion;
import java.util.Objects;

/**
 * Represents the implementation of unionTypedef.
 */
public final class UnionTypedef {

    private UnionTypedefUnion union;

    /**
     * Creates an instance of unionTypedef.
     */
    private UnionTypedef() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public UnionTypedef(UnionTypedefUnion union) {
        this.union = union;
    }

    /**
     * Returns the object of unionTypedef for type union.
     *
     * @param value value of unionTypedef for type union
     * @return unionTypedef for type union
     */
    public static UnionTypedef of(UnionTypedefUnion value) {
        return new UnionTypedef(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public UnionTypedefUnion union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(UnionTypedefUnion union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnionTypedef) {
            UnionTypedef other = (UnionTypedef) obj;
            return
                Objects.deepEquals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of unionTypedef fromString input String unionTypedef.
     *
     * @param valInString value of input String
     * @return unionTypedef
     */
    public static UnionTypedef fromString(String valInString) {
        try {
            UnionTypedefUnion tmpVal = UnionTypedefUnion.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
