/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.listinlist;

import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of list2.
 */
public class List2Keys implements KeyInfo<DefaultList2> {
    protected int key2;
    /**
     * Returns the attribute key2.
     *
     * @return key2 value of key2
     */
    public int key2() {
        return key2;
    }

    /**
     * Sets the value to attribute key2.
     *
     * @param key2 value of key2
     */
    public void key2(int key2) {
        this.key2 = key2;
    }


    @Override
    public int hashCode() {
        return Objects.hash(key2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof List2Keys) {
            List2Keys other = (List2Keys) obj;
            return
                Objects.deepEquals(key2, other.key2);
        }
        return false;
    }
}