/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.basefilter.FilterType;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of subscriptionStarted.
 */
public class DefaultSubscriptionStarted extends InnerModelObject implements SubscriptionStarted {
    protected SubscriptionId subscriptionId;
    protected StreamTypedef stream;
    protected Encoding encoding;
    protected DateAndTime startTime;
    protected DateAndTime stopTime;
    protected BitSet valueLeafFlags = new BitSet();
    protected FilterType filterType;

    @Override
    public SubscriptionId subscriptionId() {
        return subscriptionId;
    }

    @Override
    public StreamTypedef stream() {
        return stream;
    }

    @Override
    public Encoding encoding() {
        return encoding;
    }

    @Override
    public DateAndTime startTime() {
        return startTime;
    }

    @Override
    public DateAndTime stopTime() {
        return stopTime;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public FilterType filterType() {
        return filterType;
    }

    @Override
    public void subscriptionId(SubscriptionId subscriptionId) {
        valueLeafFlags.set(LeafIdentifier.SUBSCRIPTIONID.getLeafIndex());
        this.subscriptionId = subscriptionId;
    }

    @Override
    public void stream(StreamTypedef stream) {
        valueLeafFlags.set(LeafIdentifier.STREAM.getLeafIndex());
        this.stream = stream;
    }

    @Override
    public void encoding(Encoding encoding) {
        valueLeafFlags.set(LeafIdentifier.ENCODING.getLeafIndex());
        this.encoding = encoding;
    }

    @Override
    public void startTime(DateAndTime startTime) {
        valueLeafFlags.set(LeafIdentifier.STARTTIME.getLeafIndex());
        this.startTime = startTime;
    }

    @Override
    public void stopTime(DateAndTime stopTime) {
        valueLeafFlags.set(LeafIdentifier.STOPTIME.getLeafIndex());
        this.stopTime = stopTime;
    }

    @Override
    public void filterType(FilterType filterType) {
        this.filterType = filterType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(subscriptionId, stream, encoding, startTime, stopTime, valueLeafFlags, filterType);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSubscriptionStarted) {
            DefaultSubscriptionStarted other = (DefaultSubscriptionStarted) obj;
            return
                Objects.deepEquals(subscriptionId, other.subscriptionId) &&
                Objects.deepEquals(stream, other.stream) &&
                Objects.deepEquals(encoding, other.encoding) &&
                Objects.deepEquals(startTime, other.startTime) &&
                Objects.deepEquals(stopTime, other.stopTime) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(filterType, other.filterType);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("subscriptionId=" + subscriptionId)
            .add("stream=" + stream)
            .add("encoding=" + encoding)
            .add("startTime=" + startTime)
            .add("stopTime=" + stopTime)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("filterType=" + filterType)
            .toString();
    }


    /**
     * Creates an instance of defaultSubscriptionStarted.
     */
    public DefaultSubscriptionStarted() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}