/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

import java.util.List;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.filters.Filter;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of filters.
 */
public interface Filters extends Augmentable  {

    /**
     * Returns the attribute filter.
     *
     * @return filter list of filter
     */
    List<Filter> filter();

    /**
     * Sets the attribute filter.
     *
     * @param filter list of filter
     */
    void filter(List<Filter> filter);

    /**
     * Adds to the list of filter.
     *
     * @param addTo value of filter
     */
    void addToFilter(Filter addTo);

}