/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology;

import java.util.Objects;

/**
 * Represents the implementation of teGlobalId.
 */
public final class TeGlobalId {

    private long uint32;

    /**
     * Creates an instance of teGlobalId.
     */
    private TeGlobalId() {
    }

    /**
     * Creates an instance of uint32.
     *
     * @param uint32 value of uint32
     */
    public TeGlobalId(long uint32) {
        this.uint32 = uint32;
    }

    /**
     * Returns the object of teGlobalId for type uint32.
     *
     * @param value value of teGlobalId for type uint32
     * @return teGlobalId for type uint32
     */
    public static TeGlobalId of(long value) {
        return new TeGlobalId(value);
    }

    /**
     * Returns the attribute uint32.
     *
     * @return uint32 value of uint32
     */
    public long uint32() {
        return uint32;
    }
    /**
     * Sets the attribute uint32.
     *
     * @param uint32 value of uint32
     */
    public void uint32(long uint32) {
        this.uint32 = uint32;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint32);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TeGlobalId) {
            TeGlobalId other = (TeGlobalId) obj;
            return
                Objects.deepEquals(uint32, other.uint32);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(uint32);
    }
    /**
     * Returns the object of teGlobalId fromString input String teGlobalId.
     *
     * @param valInString value of input String
     * @return teGlobalId
     */
    public static TeGlobalId fromString(String valInString) {
        try {
            long tmpVal = Long.parseLong(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
