/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of clientSignalOc768Stm256.
 */
public abstract class ClientSignalOc768Stm256 extends ClientSignal {

    /**
     * Returns the attribute client-signal-OC768_STM256.
     *
     * @return client-signal-OC768_STM256 value of client-signal-OC768_STM256
     */
    public static String clientSignalOc768Stm256ToString() {
        return "client-signal-OC768_STM256";
    }

    /**
     * Returns the object of clientSignalOc768Stm256 fromString input String clientSignalOc768Stm256.
     *
     * @param valInString value of input String
     * @return clientSignalOc768Stm256
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("client-signal-OC768_STM256")) {
            return ClientSignalOc768Stm256.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}