/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of prot40Gbe.
 */
public abstract class Prot40Gbe extends TributaryProtocolType {

    /**
     * Returns the attribute prot-40GbE.
     *
     * @return prot-40GbE value of prot-40GbE
     */
    public static String prot40GbeToString() {
        return "prot-40GbE";
    }

    /**
     * Returns the object of prot40Gbe fromString input String prot40Gbe.
     *
     * @param valInString value of input String
     * @return prot40Gbe
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("prot-40GbE")) {
            return Prot40Gbe.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}