/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes;

/**
 * Represents the implementation of tsg25g.
 */
public abstract class Tsg25g extends TributarySlotGranularity {

    /**
     * Returns the attribute tsg-2.5G.
     *
     * @return tsg-2.5G value of tsg-2.5G
     */
    public static String tsg25gToString() {
        return "tsg-2.5G";
    }

    /**
     * Returns the object of tsg25g fromString input String tsg25g.
     *
     * @param valInString value of input String
     * @return tsg25g
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("tsg-2.5G")) {
            return Tsg25g.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}