/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.node.augmentedndnode;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.TpId;
import org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.node.augmentedndnode.tpoint.SupportingTerminationPoint;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of tPoint.
 */
public interface Tpoint extends Augmentable  {

    /**
     * Identify the leaf of Tpoint.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents tpId.
         */
        TPID(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute tpId.
     *
     * @return tpId value of tpId
     */
    TpId tpId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute supportingTerminationPoint.
     *
     * @return supportingTerminationPoint list of supportingTerminationPoint
     */
    List<SupportingTerminationPoint> supportingTerminationPoint();

    /**
     * Sets the attribute tpId.
     *
     * @param tpId value of tpId
     */
    void tpId(TpId tpId);

    /**
     * Sets the attribute supportingTerminationPoint.
     *
     * @param supportingTerminationPoint list of supportingTerminationPoint
     */
    void supportingTerminationPoint(List<SupportingTerminationPoint> supportingTerminationPoint);

    /**
     * Adds to the list of supportingTerminationPoint.
     *
     * @param addTo value of supportingTerminationPoint
     */
    void addToSupportingTerminationPoint(SupportingTerminationPoint addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}