/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.node.augmentedndnode;

import org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.TpId;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of tPoint.
 */
public class TpointKeys implements KeyInfo<DefaultTpoint> {
    protected TpId tpId;
    /**
     * Returns the attribute tpId.
     *
     * @return tpId value of tpId
     */
    public TpId tpId() {
        return tpId;
    }

    /**
     * Sets the value to attribute tpId.
     *
     * @param tpId value of tpId
     */
    public void tpId(TpId tpId) {
        this.tpId = tpId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(tpId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TpointKeys) {
            TpointKeys other = (TpointKeys) obj;
            return
                Objects.deepEquals(tpId, other.tpId);
        }
        return false;
    }
}