/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.cont1;

import java.util.BitSet;
import java.util.regex.Pattern;

/**
 * Represents ENUM data of leaf7.
 */
public enum Leaf7 {

    /**
     * Represents b1.
     */
    B1(0, "b1"),

    /**
     * Represents b2.
     */
    B2(1, "b2"),

    /**
     * Represents b3.
     */
    B3(2, "b3");

    private int leaf7;
    private String schemaName;

    /**
     * Creates an instance of leaf7.
     *
     * @param leaf7 value of leaf7
     */
     Leaf7(int leaf7, String schemaName) {
        this.leaf7 = leaf7;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of leaf7 for.
     *
     * @param value value of leaf7 for
     * @return leaf7 for
     */
    public static Leaf7 of(int value) {
        switch (value) {
            case 0:
                return Leaf7.B1;
            case 1:
                return Leaf7.B2;
            case 2:
                return Leaf7.B3;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of leaf7 for.
     *
     * @param value value of leaf7 for
     * @return leaf7 for
     */
    public static Leaf7 of(String value) {
        switch (value) {
            case "b1":
                return Leaf7.B1;
            case "b2":
                return Leaf7.B2;
            case "b3":
                return Leaf7.B3;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute leaf7.
     *
     * @return leaf7 value of leaf7
     */
    public int leaf7() {
        return leaf7;
    }

    /**
     * Returns the object of leaf7 fromString input String leaf7.
     *
     * @param valInString value of input String
     * @return leaf7
     */
    public static BitSet fromString(String valInString) {
        BitSet tmpVal = new BitSet();
        String[] bitNames = valInString.trim().split(Pattern.quote(" "));
        for (String bitName : bitNames) {
            Leaf7 leaf7 = of(bitName);
            if (leaf7 != null) {
                tmpVal.set(leaf7.leaf7());
            }
        }
        if (tmpVal.isEmpty()) {
            throw new IllegalArgumentException("not a valid input element");
        }
        return tmpVal;
    }
    public static String toString(BitSet bits) {
        StringBuilder sBuild = new StringBuilder("");
        if (bits.get(Leaf7.B1.leaf7())) {
            sBuild.append("b1");
            sBuild.append(" ");
        }
        if (bits.get(Leaf7.B2.leaf7())) {
            sBuild.append("b2");
            sBuild.append(" ");
        }
        if (bits.get(Leaf7.B3.leaf7())) {
            sBuild.append("b3");
            sBuild.append(" ");
        }
        return sBuild.toString();
    }
}
