/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826.ytbmodulewithcontainer.gr1;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826.ytbmodulewithcontainer.gr2.Listener;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of cont.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCont extends InnerModelObject implements Cont {
    protected List<Listener> listener;

    @Override
    public List<Listener> listener() {
        return listener;
    }

    @Override
    public void listener(List<Listener> listener) {
        this.listener = listener;
    }

    @Override
    public void addToListener(Listener addTo) {
        if (listener == null) {
            listener = new ArrayList<>();
        }
        listener.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(listener);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCont) {
            DefaultCont other = (DefaultCont) obj;
            return
                Objects.deepEquals(listener, other.listener);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("listener=" + listener)
            .toString();
    }


    /**
     * Creates an instance of defaultCont.
     */
    public DefaultCont() {
    }

}