/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedadmingroups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.namedadmingroups.namedadmingroups.NamedAdminGroup;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of namedAdminGroups.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultNamedAdminGroups extends InnerModelObject implements NamedAdminGroups {
    protected List<NamedAdminGroup> namedAdminGroup;

    @Override
    public List<NamedAdminGroup> namedAdminGroup() {
        return namedAdminGroup;
    }

    @Override
    public void namedAdminGroup(List<NamedAdminGroup> namedAdminGroup) {
        this.namedAdminGroup = namedAdminGroup;
    }

    @Override
    public void addToNamedAdminGroup(NamedAdminGroup addTo) {
        if (namedAdminGroup == null) {
            namedAdminGroup = new ArrayList<>();
        }
        namedAdminGroup.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(namedAdminGroup);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultNamedAdminGroups) {
            DefaultNamedAdminGroups other = (DefaultNamedAdminGroups) obj;
            return
                Objects.deepEquals(namedAdminGroup, other.namedAdminGroup);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("namedAdminGroup=" + namedAdminGroup)
            .toString();
    }


    /**
     * Creates an instance of defaultNamedAdminGroups.
     */
    public DefaultNamedAdminGroups() {
    }

}