/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.p2ppathpropertiesconfig;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.Srlg;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of teSrlgs.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTeSrlgs extends InnerModelObject implements TeSrlgs {
    protected List<Srlg> value;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public List<Srlg> value() {
        return value;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void value(List<Srlg> value) {
        valueLeafFlags.set(LeafIdentifier.VALUE.getLeafIndex());
        this.value = value;
    }

    @Override
    public void addToValue(Srlg addTo) {
        if (value == null) {
            value = new ArrayList<>();
        }
        value.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(value, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTeSrlgs) {
            DefaultTeSrlgs other = (DefaultTeSrlgs) obj;
            return
                Objects.deepEquals(value, other.value) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("value=" + value)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultTeSrlgs.
     */
    public DefaultTeSrlgs() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}