/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathrouteobjects;

import java.util.List;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathrouteobjects.explicitrouteobjects.ExplicitRouteObject;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of explicitRouteObjects.
 */
public interface ExplicitRouteObjects extends Augmentable  {

    /**
     * Returns the attribute explicitRouteObject.
     *
     * @return explicitRouteObject list of explicitRouteObject
     */
    List<ExplicitRouteObject> explicitRouteObject();

    /**
     * Sets the attribute explicitRouteObject.
     *
     * @param explicitRouteObject list of explicitRouteObject
     */
    void explicitRouteObject(List<ExplicitRouteObject> explicitRouteObject);

    /**
     * Adds to the list of explicitRouteObject.
     *
     * @param addTo value of explicitRouteObject
     */
    void addToExplicitRouteObject(ExplicitRouteObject addTo);

}