/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.pathrouteobjects.explicitrouteobjects;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.RouteUsageType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.explicitroutehop.Config;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.explicitroutehop.State;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of explicitRouteObject.
 */
public interface ExplicitRouteObject extends Augmentable  {

    /**
     * Identify the leaf of ExplicitRouteObject.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents index.
         */
        INDEX(1),
        /**
         * Represents explicitRouteUsage.
         */
        EXPLICITROUTEUSAGE(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute index.
     *
     * @return index value of index
     */
    Object index();

    /**
     * Returns the attribute explicitRouteUsage.
     *
     * @return explicitRouteUsage value of explicitRouteUsage
     */
    Class<? extends RouteUsageType> explicitRouteUsage();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute config.
     *
     * @return config value of config
     */
    Config config();

    /**
     * Returns the attribute state.
     *
     * @return state value of state
     */
    State state();

    /**
     * Sets the attribute index.
     *
     * @param index value of index
     */
    void index(Object index);

    /**
     * Sets the attribute explicitRouteUsage.
     *
     * @param explicitRouteUsage value of explicitRouteUsage
     */
    void explicitRouteUsage(Class<? extends RouteUsageType> explicitRouteUsage);

    /**
     * Sets the attribute config.
     *
     * @param config value of config
     */
    void config(Config config);

    /**
     * Sets the attribute state.
     *
     * @param state value of state
     */
    void state(State state);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}