/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.teoptimizationcriterion.optimizationcriterion;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TePathNumericalProperty;
import org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.teoptimizationcriterion.optimizationcriterion.metric.GoalEnum;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of metric.
 */
public interface Metric extends Augmentable  {

    /**
     * Identify the leaf of Metric.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents name.
         */
        NAME(1),
        /**
         * Represents goal.
         */
        GOAL(2),
        /**
         * Represents weight.
         */
        WEIGHT(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    Class<? extends TePathNumericalProperty> name();

    /**
     * Returns the attribute goal.
     *
     * @return goal value of goal
     */
    GoalEnum goal();

    /**
     * Returns the attribute weight.
     *
     * @return weight value of weight
     */
    short weight();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute name.
     *
     * @param name value of name
     */
    void name(Class<? extends TePathNumericalProperty> name);

    /**
     * Sets the attribute goal.
     *
     * @param goal value of goal
     */
    void goal(GoalEnum goal);

    /**
     * Sets the attribute weight.
     *
     * @param weight value of weight
     */
    void weight(short weight);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}