/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.actnietfte.rev20170310.actnietfte.tetunnelbandwidthtop.bandwidth;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeDsClass;
import org.onosproject.yang.gen.v1.yrtietftemplstypes.rev20170310.yrtietftemplstypes.BandwidthKbps;
import org.onosproject.yang.gen.v1.yrtietftemplstypes.rev20170310.yrtietftemplstypes.TeBandwidthType;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of state.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultState extends InnerModelObject implements State {
    protected TeBandwidthType specificationType;
    protected BandwidthKbps setBandwidth;
    protected TeDsClass classType;
    protected BandwidthKbps signaledBandwidth;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public TeBandwidthType specificationType() {
        return specificationType;
    }

    @Override
    public BandwidthKbps setBandwidth() {
        return setBandwidth;
    }

    @Override
    public TeDsClass classType() {
        return classType;
    }

    @Override
    public BandwidthKbps signaledBandwidth() {
        return signaledBandwidth;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void specificationType(TeBandwidthType specificationType) {
        valueLeafFlags.set(LeafIdentifier.SPECIFICATIONTYPE.getLeafIndex());
        this.specificationType = specificationType;
    }

    @Override
    public void setBandwidth(BandwidthKbps setBandwidth) {
        valueLeafFlags.set(LeafIdentifier.SETBANDWIDTH.getLeafIndex());
        this.setBandwidth = setBandwidth;
    }

    @Override
    public void classType(TeDsClass classType) {
        valueLeafFlags.set(LeafIdentifier.CLASSTYPE.getLeafIndex());
        this.classType = classType;
    }

    @Override
    public void signaledBandwidth(BandwidthKbps signaledBandwidth) {
        valueLeafFlags.set(LeafIdentifier.SIGNALEDBANDWIDTH.getLeafIndex());
        this.signaledBandwidth = signaledBandwidth;
    }

    @Override
    public int hashCode() {
        return Objects.hash(specificationType, setBandwidth, classType, signaledBandwidth, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultState) {
            DefaultState other = (DefaultState) obj;
            return
                Objects.deepEquals(specificationType, other.specificationType) &&
                Objects.deepEquals(setBandwidth, other.setBandwidth) &&
                Objects.deepEquals(classType, other.classType) &&
                Objects.deepEquals(signaledBandwidth, other.signaledBandwidth) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("specificationType=" + specificationType)
            .add("setBandwidth=" + setBandwidth)
            .add("classType=" + classType)
            .add("signaledBandwidth=" + signaledBandwidth)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultState.
     */
    public DefaultState() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}